/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.Window;
import java.util.Collections;
import javax.swing.JOptionPane;

public class ShowFWVersionAction
extends LogoAction {
    private static final long serialVersionUID = -105142723974795638L;
    public static final String SUP_SHOW_FW_VERSION = "supportShowFWVersion";
    public static final int FW_VERSION_ADDRESS = 16719619;

    public ShowFWVersionAction() {
        this.putValue("Name", "ShowFWVersion");
        this.putValue("textKey", "extra.showVersion");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.disabledContextVector = Collections.singletonList(OnlineTestTool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIt() {
        Window window = ((LogoComfort)this.getOwner()).getApplicationSurface().getWindow();
        String FWVersion = null;
        String IPAddr = "";
        String HWName = "";
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (dt instanceof TcpSocketDataTransfer) {
                IPAddr = " @" + ((TcpSocketDataTransfer)dt).getRemoteAddress();
            }
            Hardware hw = dt.getHardware();
            HWName = hw.getLocalizedName(true);
            if (hw.supports(SUP_SHOW_FW_VERSION)) {
                FWVersion = this.getFWVersion(dt);
            } else {
                JOptionPane.showMessageDialog(window, Language.getString("extra.supportShowFWVersion.notAvailable", "Function not available", HWName));
            }
        }
        catch (ExceptionAlreadyHandledException Ex) {
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
        if (FWVersion != null) {
            Log.println(Language.getString("extra.supportShowFWVersion.versionTitle", "FW version") + ": " + HWName + " " + FWVersion + IPAddr);
        } else {
            JOptionPane.showMessageDialog(window, Language.getString("extra.supportShowFWVersion.failed", "Read FW version failed."));
        }
        return true;
    }

    private String getFWVersion(DataTransfer dt) {
        int LEN = 6;
        try {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < 6; ++i) {
                ret.append((char)dt.readByte(16719619 + i));
                if (i != 1 && i != 3) continue;
                ret.append('.');
            }
            return ret.toString();
        }
        catch (TransmissionFailedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean needsWaitCursor() {
        return true;
    }

    public synchronized void setEnabled(boolean newValue) {
        if (Version.getCurrentVersion().isDemoVersion()) {
            super.setEnabled(false);
        } else {
            super.setEnabled(newValue);
        }
    }
}

